# Instance Matrix
The table below defines the instances of test hardware available on the `ubxlib` test farm and how each one is currently configured.  It is parsed and used by the functions in [u_data.py](u_data.py) to know what to do so please always ensure that it is a properly formatted Markdown format table. The columns of the table are:

- a unique instance ID: the first digit of the instance ID represents either a physical thing (a board connected via a COM port/debugger) or a distinct process (e.g. run Lint), the remaining digits represent variants, e.g. using different SDKs on a board; the second/third digit(s) of the instance ID must be used consistently (e.g. for NRF52840 variant 0 is always the nRF5 SDK, variant 1 is always the Zephyr SDK, etc.),
- the MCU field must match a unique MCU name from one of the [port/platform](/port/platform)`/<platform>/mcu/<mcu>` directories (e.g. `esp32`),
- some platforms (e.g. Zephyr and Arduino) require a board-level definition as well as an MCU; this may be provided in the "board" column,
- the platform name must match one of the [port/platform](/port/platform)`/<platform>` directories (e.g. [port/platform/esp-idf](/port/platform/esp-idf)),
  - however, if you want to run CodeChecker instead of building the firmware you should add `CodeChecker:` prefix to the platform name (e.g. `CodeChecker:STM32Cube`),
- where a choice of compilation toolchains is available the toolchain name must match a sub-directory of [port/platform](/port/platform)`/<platform>/mcu/<mcu>`,
- the module column lists the peripherals under test:
  - if a module name begins with `SARA`, `LARA` or `LENA` it will be prefixed by the test automation code with `U_CELL_MODULE_TYPE_` and then assigned to a compilation flag `U_CFG_TEST_CELL_MODULE_TYPE` for use during testing;
  - if a module name begins with `NINA`, `NORA`, `ANNA` or `ODIN` it will be prefixed by the test automation code with `U_SHORT_RANGE_MODULE_TYPE_` and then assigned to a compilation flag `U_CFG_TEST_SHORT_RANGE_MODULE_TYPE` for use during testing; note that for the case where the SHO on-board Wi-Fi/BLE client is employed no module name is given and instead the compilation flag `U_CFG_BLE_MODULE_INTERNAL` is added in the \#defines column,
  - otherwise the module will be assumed to be GNSS and will be prefixed by the test automation code with `U_GNSS_MODULE_TYPE_` and then assigned to a compilation flag `U_CFG_TEST_GNSS_MODULE_TYPE`  for use during testing,
- all APIs that exist on an instance will usually be tested, the "APIs available" column is used by the [u_select.py](u_select.py) automation script (see [README.md](README.md#script-usage)) to select the instances that should be run where only a single API is affected by a change, e.g. if only the [at_client](/common/at_client) is affected by a change then only those instances that have `at_client` in this column will be run; the name here must match one in the directory structure (e.g. `mqtt_client` for the [common/mqtt_client](/common/mqtt_client) API),
- the `ubxlib` features to include, where empty means the default, which is all of `cell`, `gnss` and `short_range`,
- lastly, overrides to or additional compilation flags may be supplied in the final column.

|  ID   | Description                                |     MCU     |    Board    | Platform  | Toolchain  | Module(s) (separate with spaces) |  APIs available (separate with spaces)      |UBXLIB_FEATURES| \#define overrides (separate with spaces) |
| :---: | ------------------------------------------ | :---------: | :---------: | :-------: | :--------: | :------------------------------: | ------------------------------------------- |---------------| ---------------------------------------- |
| 1     | Doxygen                                    |             |             |           |            |                                  |                                             |               | U_CFG_GEOFENCE                           |
| 2     | AStyle style checker                       |             |             |           |            |                                  |                                             |               | U_CFG_GEOFENCE                           |
| 3     | Pylint                                     |             |             |           |            |                                  |                                             |               |                                          |
| 4.1   | Static size check                          |             |             |           |            |                                  |                                             |               |                                          |
| 4.2   | Static size check, cell only               |             |             |           |            | SARA_R5                          |                                             | cell          |                                          |
| 4.3.0 | Static size check, gnss only               |             |             |           |            | M9                               |                                             | gnss          |                                          |
| 4.3.1 | Static size check, gnss only, geofence     |             |             |           |            | M9                               |                                             | gnss          | U_CFG_GEOFENCE                           |
| 4.4.0 | Static size check, short-range only        |             |             |           |            | NINA_W15                         |                                             | short_range   |                                          |
| 4.4.1 | Static size check, short-range gen 2 only  |             |             |           |            | NORA_W36                         |                                             | short_range short_range_gen2 |                           |
| 5.1.0 | Check no floating point                    |             |             |           |            |                                  |                                             |               |                                          |
| 5.1.1 | Check no floating point, short-range gen 2 |             |             |           |            |                                  |                                             | short_range short_range_gen2 |                           |
| 5.2.0 | Check build without logging                |             |             |           |            |                                  |                                             |               | U_CFG_ENABLE_LOGGING=0 U_CFG_GEOFENCE    |
| 5.2.1 | Check build without logging, SHO gen 2     |             |             |           |            |                                  |                                             | short_range short_range_gen2 | U_CFG_ENABLE_LOGGING=0    |
| 5.3   | Check public headers not in ubxlib.h       |             |             |           |            |                                  |                                             |               | U_CFG_GEOFENCE                           |
| 5.4   | Check malloc()/free() being called         |             |             |           |            |                                  |                                             |               | U_CFG_GEOFENCE                           |
| 6.1.0 | CodeChecker (Zephyr)                       |   NRF5340   | ubx_evkninab3_nrf52840  | CodeChecker:Zephyr  | | SARA_R5 M8 NINA_W15   |                                             |               | U_CFG_BLE_MODULE_INTERNAL U_CFG_PPP_ENABLE U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_BLE_TEST_CFG_REMOTE_SPS_PERIPHERAL=2462ABB6EAC6p U_CFG_APP_SHORT_RANGE_ROLE=1 U_CFG_TEST_NET_STATUS_CELL U_CFG_TEST_NET_STATUS_SHORT_RANGE U_DEBUG_UTILS_DUMP_THREADS U_CFG_HEAP_MONITOR |
| 6.1.1 | CodeChecker (Zephyr), short-range gen 2    |   NRF52833  | ubx_evkninab4_nrf52833  | CodeChecker:Zephyr  | | SARA_R5 NORA_W36      |                                             | short_range short_range_gen2 | U_CFG_BLE_MODULE_INTERNAL U_CFG_PPP_ENABLE U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_BLE_TEST_CFG_REMOTE_SPS_PERIPHERAL=2462ABB6EAC6p U_CFG_APP_SHORT_RANGE_ROLE=1 U_CFG_TEST_NET_STATUS_SHORT_RANGE U_DEBUG_UTILS_DUMP_THREADS U_CFG_HEAP_MONITOR |
| 6.2.0 | CodeChecker (STM32Cube)                    |   STM32F4   |             | CodeChecker:STM32Cube || SARA_R5 NINA_W15 M8              |                                             |               | U_CFG_APP_PIN_SHORT_RANGE_RESET_TO_DEFAULTS=0x42 U_CFG_SARA_R5_M8_WORKAROUND U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_CFG_TEST_NET_STATUS_CELL U_CFG_TEST_NET_STATUS_SHORT_RANGE U_DEBUG_UTILS_DUMP_THREADS U_CFG_HEAP_MONITOR |
| 6.2.1 | CodeChecker (STM32Cube) with geofence      |   STM32F4   |             | CodeChecker:STM32Cube || SARA_R5 NINA_W15 M8              |                                             |               | U_CFG_GEOFENCE U_CFG_APP_PIN_SHORT_RANGE_RESET_TO_DEFAULTS=0x42 U_CFG_SARA_R5_M8_WORKAROUND U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_CFG_TEST_NET_STATUS_CELL U_CFG_TEST_NET_STATUS_SHORT_RANGE U_DEBUG_UTILS_DUMP_THREADS U_CFG_HEAP_MONITOR |
| 7     | Build PIO examples                         |             |             |           |            |                                  |                                             |               |                                          |
| 8     | Build as a Zephyr module                   |   NRF5340   | nrf5340dk_nrf5340_cpuapp |           |                                  |                                             |               |                                          |
| 10.0  | ESP32-DevKitC                              |    ESP32    |             |  ESP-IDF  |            | M10                              | port ubx_protocol gnss spartn geofence      | gnss geodesic | U_CFG_GEOFENCE U_CFG_GNSS_FENCE_USE_GEODESIC U_CFG_APP_GNSS_I2C=0 U_CFG_TEST_PIN_GNSS_RESET_N=23 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_CFG_MUTEX_DEBUG U_DEBUG_UTILS_DUMP_THREADS |
| 10.2.0| ESP32-DevKitC                              |    ESP32    | esp-wrover-kit | platformio | espidf | M10                              | port device network                         |               | U_CFG_APP_FILTER=port.example. U_CFG_APP_GNSS_I2C=0 U_CFG_TEST_PIN_GNSS_RESET_N=23 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 |
| 10.2.1| ESP32-DevKitC                              |    ESP32    | esp-wrover-kit | platformio | espidf | M10                              | port device network                         | gnss          | U_CFG_APP_FILTER=port.example.gnssInfo. U_CFG_APP_GNSS_I2C=0 U_CFG_TEST_PIN_GNSS_RESET_N=23 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 |
| 11.0  | ESP32-DevKitC                              |    ESP32    |             |  ESP-IDF  |            | M9                               | port at_client ubx_protocol gnss spartn     |               | U_CFG_APP_GNSS_SPI=2 U_CFG_TEST_PIN_GNSS_RESET_N=25 U_GNSS_MGA_TEST_HAS_FLASH U_CFG_MUTEX_DEBUG U_CFG_TEST_UART_B=1 U_CFG_TEST_PIN_UART_A_CTS=-1 U_CFG_TEST_PIN_UART_A_RTS=-1 U_CFG_TEST_PIN_UART_A_RXD=26 U_CFG_TEST_PIN_UART_B_TXD=27 U_CFG_TEST_PIN_UART_B_RXD=14 U_DEBUG_UTILS_DUMP_THREADS |
| 11.1  | ESP32-DevKitC                              |    ESP32    | esp32:esp32:esp32doit-devkit-v1 | Arduino | ESP-IDF | M9                | port at_client ubx_protocol gnss spartn     |               | U_CFG_APP_GNSS_SPI=2 U_CFG_TEST_PIN_GNSS_RESET_N=25 U_GNSS_MGA_TEST_HAS_FLASH U_CFG_TEST_UART_B=1 U_CFG_TEST_PIN_UART_A_CTS=-1 U_CFG_TEST_PIN_UART_A_RTS=-1 U_CFG_TEST_PIN_UART_A_RXD=26 U_CFG_TEST_PIN_UART_B_TXD=27 U_CFG_TEST_PIN_UART_B_RXD=14 |
| 11.2  | ESP32-DevKitC                              |    ESP32    | esp-wrover-kit | platformio | arduino | M9                              | port device network                         |               | U_CFG_APP_FILTER=port.example. U_CFG_APP_GNSS_SPI=2 U_GNSS_MGA_TEST_HAS_FLASH U_CFG_TEST_PIN_GNSS_RESET_N=25 |
| 12.0  | ESP32-DevKitC + EVK, Cat M1, uConnect      |    ESP32    |             |  ESP-IDF  |            | SARA_R5 M8 NINA_W15              | port device network sock ble wifi cell short_range security mqtt_client http_client gnss location || U_CFG_PPP_ENABLE U_CELL_TEST_MUX_ALWAYS U_CFG_TEST_SECURITY_DISABLE U_CFG_TEST_CELL_PWR_DISABLE U_CFG_APP_PIN_SHORT_RANGE_RESET_TO_DEFAULTS=2 U_CFG_APP_PIN_SHORT_RANGE_CTS=22 U_CFG_APP_PIN_SHORT_RANGE_RTS=23 U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CFG_SARA_R5_M8_WORKAROUND U_CFG_APP_CELL_PIN_GNSS_POWER=-1 U_CFG_APP_CELL_PIN_GNSS_DATA_READY=-1 U_CFG_APP_PIN_CELL_TXD=21 U_CFG_APP_PIN_CELL_RXD=19 U_CFG_APP_PIN_CELL_VINT=-1 U_CFG_APP_PIN_CELL_ENABLE_POWER=-1 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_DEBUG_UTILS_DUMP_THREADS |
| 12.2.0| ESP32-DevKitC + EVK, Cat M1, uConnect      |    ESP32    | esp-wrover-kit | platformio | espidf | SARA_R5 M8 NINA_W15              | port device network                         |               | U_CFG_APP_FILTER=port.example.gnssInfo. U_CFG_APP_PIN_SHORT_RANGE_RESET_TO_DEFAULTS=2 U_CFG_APP_PIN_SHORT_RANGE_CTS=22 U_CFG_APP_PIN_SHORT_RANGE_RTS=23 U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CFG_SARA_R5_M8_WORKAROUND U_CFG_APP_CELL_PIN_GNSS_POWER=-1 U_CFG_APP_CELL_PIN_GNSS_DATA_READY=-1 U_CFG_APP_PIN_CELL_TXD=21 U_CFG_APP_PIN_CELL_RXD=19 U_CFG_APP_PIN_CELL_VINT=-1 U_CFG_APP_PIN_CELL_ENABLE_POWER=-1 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p |
| 12.2.1| ESP32-DevKitC + EVK, Cat M1                |    ESP32    | esp-wrover-kit | platformio | espidf | SARA_R5                          | port device network                         | cell          | U_CFG_APP_FILTER=cellInfo.cellSim. U_CFG_TEST_SECURITY_DISABLE U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CFG_APP_PIN_SHORT_RANGE_CTS=22 U_CFG_APP_PIN_SHORT_RANGE_RTS=23 U_CFG_SARA_R5_M8_WORKAROUND U_CFG_APP_CELL_PIN_GNSS_POWER=-1 U_CFG_APP_CELL_PIN_GNSS_DATA_READY=-1 U_CFG_APP_PIN_CELL_TXD=21 U_CFG_APP_PIN_CELL_RXD=19 U_CFG_APP_PIN_CELL_VINT=-1 U_CFG_APP_PIN_CELL_ENABLE_POWER=-1 |
| 12.2.2| ESP32-DevKitC + EVK, Cat M1, uConnect      |    ESP32    | esp-wrover-kit | platformio | espidf | NINA_W15                         | port device network                         | short_range   | U_CFG_APP_FILTER=wifiStation. U_CFG_APP_PIN_SHORT_RANGE_RESET_TO_DEFAULTS=2 U_CFG_APP_PIN_SHORT_RANGE_CTS=22 U_CFG_APP_PIN_SHORT_RANGE_RTS=23 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p |
| 13.0.0| Nordic DK board (NRF52840) + EVK, Cat M1   |  NRF52840   |             |  nRF5SDK  |     GCC    | SARA_R5 M10                      | port at_client cell sock network mqtt_client ubx_protocol gnss spartn || U_CFG_TEST_GNSS_ASSIST_NOW_DISABLE U_CFG_TEST_CELL_PWR_DISABLE U_CFG_TEST_MQTT_CLIENT_SN_DISABLE_CONNECTIVITY_TEST U_CELL_CFG_SARA_R5_00B U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CFG_APP_GNSS_I2C=1 U_CFG_TEST_PIN_GNSS_RESET_N=29 U_CFG_TEST_UART_B=0 U_CFG_TEST_PIN_UART_A_CTS=-1 U_CFG_TEST_PIN_UART_A_RTS=-1 U_CFG_TEST_PIN_UART_B_TXD=44 U_CFG_TEST_PIN_UART_B_RXD=43 U_CFG_TEST_PIN_UART_A_RXD=45 U_DEBUG_UTILS_DUMP_THREADS |
| 13.1.0| Nordic DK board (NRF52840) + EVK           |  NRF52840   | nrf52840dk_nrf52840 | Zephyr |       |                                  | port at_client ubx_protocol spartn          | short_range   | U_CFG_TEST_UART_B=0 U_DEBUG_UTILS_DUMP_THREADS |
| 13.1.1| Nordic DK board (NRF52840) + EVK, DT cfg   |  NRF52840   | ubx_evkninab3_nrf52840 | Zephyr |    |                                  | port                                        |               | U_CFG_APP_FILTER=zephyrPort. U_CFG_PPP_ENABLE U_CFG_TEST_UART_A=-1 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 |
| 14    | STM32F407 Discovery + EVK, Cat M1          |   STM32F4   |             | STM32Cube |            | SARA_R422 M9                     | port device network sock security cell mqtt_client http_client gnss location || CMSIS_V2 U_CFG_TEST_CELL_PWR_DISABLE U_CFG_TEST_GNSS_ASSIST_NOW U_GNSS_MGA_TEST_HAS_FLASH U_LOCATION_TEST_DISABLE U_CFG_1V8_SIM_WORKAROUND HSE_VALUE=8000000U U_CFG_APP_GNSS_SPI=2 U_CFG_APP_PIN_GNSS_SPI_MOSI=0x1F U_CFG_APP_PIN_GNSS_SPI_MISO=0x1E U_CFG_APP_PIN_GNSS_SPI_CLK=0x1D U_CFG_APP_PIN_GNSS_SPI_SELECT=0x1C U_CFG_TEST_PIN_GNSS_RESET_N=0x40 U_CFG_TEST_PIN_C=0x3F U_CFG_APP_GNSS_UART=-1 U_CFG_APP_PIN_GNSS_ENABLE_POWER=-1 U_CFG_TEST_UART_A=-1 U_CFG_APP_PIN_C030_ENABLE_3V3=-1 U_CFG_APP_PIN_CELL_RESET=-1 U_CFG_APP_CELL_UART=3 U_CFG_APP_PIN_CELL_TXD=0x38 U_CFG_APP_PIN_CELL_RXD=0x39 U_CFG_APP_PIN_CELL_RTS=-1 U_CFG_APP_PIN_CELL_CTS=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 15.0.0| Nordic DK board (NRF52840) + EVK           |  NRF52840   |             |  nRF5SDK  |     GCC    | M9                               | port gnss device                            | gnss          | U_CFG_APP_GNSS_SPI=3 U_CFG_TEST_PIN_GNSS_RESET_N=37 U_GNSS_MGA_TEST_HAS_FLASH U_CFG_MUTEX_DEBUG U_DEBUG_UTILS_DUMP_THREADS |
| 15.1  | Nordic DK board (NRF52840) + EVK           |  NRF52840   | nrf52840dk_nrf52840 | Zephyr |       | M9                               | port device network ble short_range gnss    |               | U_CFG_TEST_UART_A=-1 U_CFG_APP_GNSS_SPI=3 U_CFG_APP_PIN_GNSS_SPI_SELECT=29 U_CFG_TEST_PIN_GNSS_RESET_N=37 U_GNSS_MGA_TEST_HAS_FLASH U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_DEBUG_UTILS_DUMP_THREADS |
| 16    | STM32F407 Discovery                        |   STM32F4   |             | STM32Cube |            | M10                              | port ubx_protocol gnss spartn geofence      | gnss          | U_CFG_GEOFENCE HSE_VALUE=8000000U U_PORT_TEST_DISABLE_I2C U_GNSS_MGA_TEST_DISABLE_DATABASE U_CFG_APP_GNSS_I2C=1 U_CFG_TEST_PIN_GNSS_RESET_N=0x40 U_CFG_APP_GNSS_UART=-1 U_CFG_APP_PIN_GNSS_ENABLE_POWER=-1 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_CFG_APP_PIN_C030_ENABLE_3V3=-1 U_CFG_APP_PIN_CELL_RESET=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 17.1.0| Nordic NRF5340 DK board                    |   NRF5340   | nrf5340dk_nrf5340_cpuapp | Zephyr  | | M9                               | port device network ble short_range lib_common ubx_protocol gnss spartn || U_CFG_APP_GNSS_SPI=2 U_CFG_APP_SPI_MAX_SEGMENT_SIZE=32 U_CFG_APP_PIN_GNSS_SPI_SELECT=46 U_CFG_TEST_PIN_GNSS_RESET_N=37 U_GNSS_MGA_TEST_HAS_FLASH U_CFG_BLE_MODULE_INTERNAL U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_BLE_TEST_CFG_REMOTE_SPS_PERIPHERAL=2462ABB6EAC6p U_CFG_APP_SHORT_RANGE_ROLE=1 U_DEBUG_UTILS_DUMP_THREADS |
| 17.1.1| Nordic NRF5340 DK board                    |   NRF5340   | nrf5340dk_nrf5340_cpuapp | Zephyr  | | M9                               | port                                        | gnss          | U_CFG_APP_FILTER=port U_CFG_APP_GNSS_SPI=2 U_CFG_TEST_GNSS_SPI_SELECT_INDEX=1 U_CFG_APP_PIN_GNSS_SPI_SELECT=46 U_CFG_TEST_PIN_GNSS_RESET_N=37 U_GNSS_MGA_TEST_HAS_FLASH U_DEBUG_UTILS_DUMP_THREADS |
| 18    | NORA-B1 NRF5340 DK board + EVK, Cat M1     |   NRF5340   | nrf5340dk_nrf5340_cpuapp | Zephyr  | | SARA_R5 M8                       | port device network sock security cell lib_common mqtt_client http_client gnss location || U_CELL_TEST_MUX_ALWAYS U_CFG_TEST_CELL_PWR_DISABLE U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CFG_TEST_CLOUD_LOCATE U_CFG_TEST_CELL_LOCATE U_CFG_TEST_GNSS_ASSIST_NOW U_CFG_SARA_R5_M8_WORKAROUND U_CFG_APP_PIN_CELL_DTR=37 U_CFG_APP_PIN_CELL_PWR_ON=36 U_CFG_APP_CELL_PIN_GNSS_POWER=-1 U_CFG_APP_CELL_PIN_GNSS_DATA_READY=-1 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 19    | C030-R5 board (STM32F437), Cat M1, uConnect|   STM32F4   |             | STM32Cube |            | SARA_R5 NINA_W15 M8              | port device network sock ble wifi cell short_range security mqtt_client http_client ubx_protocol spartn gnss location || U_CFG_TEST_CELL_PWR_DISABLE U_CFG_APP_PIN_SHORT_RANGE_RESET_TO_DEFAULTS=0x42 U_CFG_SARA_R5_M8_WORKAROUND U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_DEBUG_UTILS_DUMP_THREADS |
| 20    | WHRE board (NINA-W1), Cat M1               |    ESP32    |             |  ESP-IDF  |            | SARA_R412M_02B                   | cell mqtt_client                            |               | U_CFG_APP_FILTER=cellMqtt.mqttClient.exampleMqtt.cellMuxMqtt.cellCfgGreeting.cellInfo.cellCfgTime.cellSim. U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 21    | WHRE board (NINA-W1), Cat M1               |    ESP32    |             |  ESP-IDF  |            | SARA_R410M_02B                   | cell mqtt_client                            |               | U_CFG_APP_FILTER=cellMqtt.mqttClient.exampleMqtt.cellMuxMqtt.cellCfgGreeting.cellInfo.cellCfgTime.cellSim. U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 22.0  | NINA-W1 + EVK, Cat M1                      |    ESP32    | esp32:esp32:nina_w10 | Arduino | ESP-IDF | SARA_R422 M8                 | port device network sock security cell mqtt_client http_client gnss location || U_CFG_PPP_ENABLE U_CFG_TEST_CELL_PWR_DISABLE U_GNSS_TEST_DISABLE_ACTIVE_ANTENNA_DISABLE U_CFG_MONITOR_DTR_RTS_OFF U_CFG_1V8_SIM_WORKAROUND U_CFG_APP_PIN_CELL_ENABLE_POWER=-1 U_CFG_APP_PIN_CELL_VINT=-1 U_CFG_APP_PIN_CELL_PWR_ON=5 U_CFG_APP_PIN_CELL_TXD=14 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 22.1  | EVK, Cat M1                                |    ESP32    |             | ESP-IDF   |            | SARA_R422                        | port                                        |               | U_CFG_APP_FILTER=espidf. U_CFG_PPP_ENABLE U_CFG_TEST_CELL_PWR_DISABLE U_CFG_MONITOR_DTR_RTS_OFF U_CFG_1V8_SIM_WORKAROUND U_CFG_APP_PIN_CELL_ENABLE_POWER=-1 U_CFG_APP_PIN_CELL_VINT=-1 U_CFG_APP_PIN_CELL_PWR_ON=5 U_CFG_APP_PIN_CELL_TXD=14 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 23    | Windows + EVK, Cat M1, uConnect            |    WIN32    |             |  WINDOWS  |    MSVC    | SARA_R5 M8 NINA_W15              | port device network sock ble wifi cell short_range security mqtt_client http_client ubx_protocol gnss spartn location geofence |cell short_range gnss geodesic| U_CFG_TEST_TIMEOUT_SPEED_UP=14 U_CFG_GEOFENCE U_AT_CLIENT_PRINT_WITH_TIMESTAMP U_CFG_HEAP_MONITOR U_ASSERT_HOOK_FUNCTION_TEST_RETURN U_CFG_TEST_DISABLE_GREETING_CALLBACK U_CFG_MUTEX_DEBUG U_NETWORK_GNSS_CFG_CELL_USE_AT_ONLY U_GNSS_MSG_TEST_MESSAGE_RECEIVE_NON_BLOCKING_PRINT U_CFG_TEST_NET_STATUS_CELL=RF_SWITCH_A U_CFG_TEST_NET_STATUS_SHORT_RANGE=PWR_SWITCH_A U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=6009C390E4DAp U_CFG_TEST_UART_A=100 U_CFG_APP_SHORT_RANGE_UART=101 U_CFG_APP_SHORT_RANGE_UART2=104 U_CFG_APP_CELL_UART=102 U_CFG_QUEUE_DEBUG |
| 24.0  | Linux/Posix under Zephyr                   |   LINUX32   | native_posix |  Zephyr  |            |                                  | port gnss geofence                          | gnss geodesic | U_CFG_APP_FILTER=port.atClient.gnssFenceStandalone. U_CFG_GEOFENCE U_CFG_GNSS_FENCE_USE_GEODESIC  U_CFG_HEAP_MONITOR U_ASSERT_HOOK_FUNCTION_TEST_RETURN U_CFG_MUTEX_DEBUG U_CFG_TEST_UART_A=0 U_CFG_TEST_UART_B=1 |
| 24.1  | Linux + EVK, live network                  |   LINUX64   |             |   Linux   |            | LARA_R6                          | port                                        |               | U_CFG_APP_FILTER=port.examplePppLinuxSockets. U_CFG_PPP_ENABLE U_CFG_HEAP_MONITOR U_CFG_APP_CELL_UART=0 U_CFG_APP_CELL_UART_PPP=1 U_CFG_APP_UART_PREFIX=/dev/ublox_lara_r6_usb_at_ U_CELL_TEST_CFG_APN=iot.1nce.net U_CELL_CFG_APN_DEFAULT=iot.1nce.net U_CELL_TEST_NO_INVALID_APN U_CELL_TEST_CFG_BANDMASK1=0x0000000000080084ULL U_CELL_NET_TEST_RAT=U_CELL_NET_RAT_LTE U_CELL_TEST_CFG_MNO_PROFILE=90 U_CFG_MUTEX_DEBUG |
| 25    | HPG Solution board (NINA-W1), live network |    ESP32    |             |  ESP-IDF  |            | LARA_R6 M9                       | port device network sock cell security mqtt_client gnss location geofence || U_CFG_GEOFENCE U_CFG_TEST_GNSS_POWER_SAVING_NOT_SUPPORTED U_CFG_TEST_DISABLE_MUX U_GNSS_MGA_TEST_ASSIST_NOW_AUTONOMOUS_NOT_SUPPORTED U_NETWORK_GNSS_CFG_CELL_USE_AT_ONLY U_HTTP_CLIENT_DISABLE_TEST U_CELL_CFG_TEST_USE_FIXED_TIME_SECONDS U_CFG_TEST_CELL_GEOFENCE U_CFG_MONITOR_DTR_RTS_OFF U_CELL_TEST_NO_INVALID_APN U_CELL_TEST_CFG_BANDMASK1=0x0000000000080084ULL U_CELL_NET_TEST_RAT=U_CELL_NET_RAT_LTE U_CELL_TEST_CFG_MNO_PROFILE=90 U_CFG_APP_PIN_CELL_ENABLE_POWER=-1 U_CFG_APP_PIN_CELL_PWR_ON=0x800c U_CFG_APP_PIN_CELL_RESET=13 U_CELL_RESET_PIN_DRIVE_MODE=U_PORT_GPIO_DRIVE_MODE_NORMAL U_CFG_APP_PIN_CELL_VINT=0x8025 U_CFG_APP_PIN_CELL_DTR=15 U_CFG_APP_PIN_CELL_TXD=25 U_CFG_APP_PIN_CELL_RXD=26 U_CFG_APP_PIN_CELL_RTS=27 U_CFG_APP_PIN_CELL_CTS=36 U_CFG_APP_GNSS_I2C=0 U_GNSS_TEST_I2C_ADDRESS_EXTRA=0x43 U_CFG_APP_CELL_PIN_GNSS_POWER=-1 U_CFG_APP_CELL_PIN_GNSS_DATA_READY=-1 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 26    | NINA-B4                                    |  NRF52833   | ubx_evkninab4_nrf52833 | Zephyr |    | M10                              | port ubx_protocol gnss spartn               |               | U_CFG_APP_GNSS_I2C=0 U_CFG_APP_I2C_MAX_SEGMENT_SIZE=32 U_CFG_TEST_PIN_GNSS_RESET_N=30 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 |
| 27    | ESP32S3-DevKitC                            |   ESP32S3   |             |  ESP-IDF  |            | M9                               | port ubx_protocol gnss spartn               |               | U_CFG_TEST_GNSS_POWER_SAVING_NOT_SUPPORTED U_CFG_APP_GNSS_I2C=0 U_CFG_TEST_PIN_GNSS_RESET_N=40 U_GNSS_MGA_TEST_ASSIST_NOW_AUTONOMOUS_NOT_SUPPORTED U_CFG_TEST_PIN_A=1 U_CFG_TEST_PIN_B=9 U_CFG_TEST_PIN_C=38 U_CFG_TEST_PIN_UART_A_CTS=11 U_CFG_TEST_PIN_UART_A_RTS=47 U_CFG_TEST_PIN_UART_A_RXD=10 U_CFG_TEST_PIN_UART_A_TXD=48 U_CFG_APP_PIN_GNSS_SDA=18 U_CFG_APP_PIN_GNSS_SCL=17 U_CFG_MUTEX_DEBUG U_DEBUG_UTILS_DUMP_THREADS |
| 28    | Linux + EVK, Cat M1, uConnect              |   LINUX64   |             |   Linux   |            | SARA_R5 M9 NINA_W15              | port device network sock ble wifi cell short_range security mqtt_client http_client ubx_protocol gnss spartn location geofence |cell short_range gnss geodesic | U_CFG_PPP_ENABLE U_CFG_GEOFENCE U_CFG_HEAP_MONITOR U_ASSERT_HOOK_FUNCTION_TEST_RETURN U_CFG_TEST_USE_VALGRIND U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CFG_APP_UART_PREFIX=/dev/ttyAMA U_CFG_APP_CELL_UART=0 U_CFG_APP_PIN_CELL_PWR_ON=25 U_CELL_PWR_ON_PIN_DRIVE_MODE=U_PORT_GPIO_DRIVE_MODE_NORMAL U_CFG_APP_SHORT_RANGE_UART=1 U_CFG_APP_PIN_SHORT_RANGE_RESET_TO_DEFAULTS=26 U_CFG_APP_PIN_SHORT_RANGE_CTS=0 U_CFG_APP_PIN_SHORT_RANGE_RTS=0 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_CFG_TEST_GNSS_SPI_SELECT_INDEX=0 U_CFG_APP_GNSS_SPI=0 U_CFG_APP_GNSS_I2C=8 U_CFG_TEST_PIN_GNSS_RESET_N=19 U_GNSS_MGA_TEST_HAS_FLASH U_CFG_TEST_UART_PREFIX=/tmp/ttyv U_CFG_TEST_UART_A=0 U_CFG_TEST_UART_B=1 U_AT_CLIENT_TEST_AT_TIMEOUT_TOLERANCE_MS=1000 U_CFG_TEST_PIN_A=17 U_CFG_TEST_PIN_B=27 U_CFG_TEST_PIN_C=22 U_CFG_MUTEX_DEBUG |
| 29    | HPG C214 board (NINA-W1), live network     |    ESP32    |             |  ESP-IDF  |            | LENA_R8 M9                       | port device network sock cell security mqtt_client gnss location || U_CFG_PPP_ENABLE U_HTTP_CLIENT_DISABLE_TEST U_CELL_GPIO_DISABLE_TEST U_MQTT_CLIENT_TEST_NO_NULL_SEND U_CFG_TEST_GNSS_POWER_SAVING_NOT_SUPPORTED U_GNSS_MGA_TEST_ASSIST_NOW_AUTONOMOUS_NOT_SUPPORTED U_CELL_CFG_TEST_USE_FIXED_TIME_SECONDS U_CFG_MONITOR_DTR_RTS_OFF U_CELL_TEST_NO_INVALID_APN U_CELL_TEST_CFG_BANDMASK1=0x0000000000080084ULL U_CELL_NET_TEST_RAT=U_CELL_NET_RAT_LTE U_CFG_APP_PIN_CELL_ENABLE_POWER=-1 U_CFG_APP_PIN_CELL_PWR_ON=0x801a U_CFG_APP_PIN_CELL_RESET=33 U_CELL_RESET_PIN_DRIVE_MODE=U_PORT_GPIO_DRIVE_MODE_NORMAL U_CFG_APP_PIN_CELL_VINT=0x8025 U_CFG_APP_PIN_CELL_DTR=15 U_CFG_APP_PIN_CELL_TXD=25 U_CFG_APP_PIN_CELL_RXD=34 U_CFG_APP_PIN_CELL_RTS=27 U_CFG_APP_PIN_CELL_CTS=36 U_CFG_APP_GNSS_I2C=0 U_GNSS_TEST_I2C_ADDRESS_EXTRA=0x43 U_CFG_APP_CELL_PIN_GNSS_POWER=-1 U_CFG_APP_CELL_PIN_GNSS_DATA_READY=-1 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |
| 30    | STM32F407 Discovery, NORA-W3, SARA-R520 EVK|   STM32F4   |             | STM32Cube |            | SARA_R52 M10 NORA_W36            | port device network sock cell ble wifi short_range gnss security mqtt_client http_client location | cell gnss short_range short_range_gen2 | CMSIS_V2 HSE_VALUE=8000000U U_CFG_TEST_GNSS_POWER_SAVING_NOT_SUPPORTED U_CFG_APP_GNSS_UART=-1 U_CFG_LOC_TEST_CHANGE_SYSTEM_TYPES_DISABLE U_CFG_APP_PIN_C030_ENABLE_3V3=-1 U_CFG_APP_PIN_CELL_RESET=-1 U_CFG_APP_CELL_UART=2 U_CFG_APP_PIN_CELL_TXD=0x03 U_CFG_APP_PIN_CELL_RXD=0x02 U_CFG_APP_PIN_CELL_RTS=-1 U_CFG_APP_PIN_CELL_CTS=-1 U_CFG_TEST_PIN_A=-1 U_CFG_TEST_PIN_B=-1 U_CFG_TEST_PIN_C=-1 U_CFG_TEST_UART_A=-1 U_BLE_TEST_CFG_REMOTE_SPS_CENTRAL=2462ABB6CC42p U_BLE_TEST_CFG_REMOTE_SPS_PERIPHERAL=2462ABB6EAC6p U_CFG_APP_SHORT_RANGE_ROLE=3 U_CFG_APP_SHORT_RANGE_UART2=6 U_CFG_APP_PIN_SHORT_RANGE_TXD2=0x26 U_CFG_APP_PIN_SHORT_RANGE_RXD2=0x27 U_DEBUG_UTILS_DUMP_THREADS U_CFG_TEST_GNSS_TRANSPORT_AT_DISABLE |
| 31    | STM32F7, Nucleo-F767ZI, LARA-R6, live net  |    STM32    | nucleo_f767zi | Zephyr  |            | LARA_R6                          | port device network sock cell security mqtt_client http_client location || U_CFG_TEST_DISABLE_MUX U_CFG_TEST_CELL_PWR_DISABLE U_CELL_TEST_CFG_APN=iot.1nce.net U_CELL_CFG_TEST_USE_FIXED_TIME_SECONDS U_CELL_TEST_NO_INVALID_APN U_CELL_TEST_CFG_BANDMASK1=0x0000000000080084ULL U_CELL_NET_TEST_RAT=U_CELL_NET_RAT_LTE U_CELL_TEST_CFG_MNO_PROFILE=90 U_DEBUG_UTILS_DUMP_THREADS |
| 32    | STM32U5, Nucleo-U575ZI-q                   |    STM32    | nucleo_u575zi_q | Zephyr |           | SARA_U201 M9                     | port device network sock cell security http_client location gnss ubx_protocol gnss spartn | | U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CELL_NET_TEST_RAT=U_CELL_NET_RAT_GSM_GPRS_EGPRS U_CELL_TEST_CFG_APN=iot.1nce.net U_CELL_CFG_APN_DEFAULT=iot.1nce.net U_CFG_TEST_TRANSPORT_SECURITY_DISABLE U_CELL_CFG_TEST_USE_FIXED_TIME_SECONDS U_CELL_TEST_NO_INVALID_APN U_CFG_CELL_DISABLE_UART_POWER_SAVING U_CFG_APP_GNSS_I2C=1 U_CFG_APP_I2C_MAX_SEGMENT_SIZE=255 U_GNSS_MGA_TEST_HAS_FLASH U_CFG_TEST_GNSS_POWER_SAVING_NOT_SUPPORTED U_GNSS_MGA_TEST_ASSIST_NOW_AUTONOMOUS_NOT_SUPPORTED U_CFG_TEST_PIN_GNSS_RESET_N=0x5D U_CFG_TEST_UART_A=-1 U_DEBUG_UTILS_DUMP_THREADS |

Notes:
- the \#defines listed are *overrides* on the default values that are defined in the code or additional to those defined in the code; they are not a complete list,
- the instances on which `at_client` is available to test use the same wiring as the other boards but allocate UARTs to pins differently: two UARTs are used for back-to-back testing, no flow control, and the CTS/RTS pins that are back-to-back connected for `port` UART testing are instead allocated to the second UART; on these instances the `port` UART test will be skipped,
- the cellular tests take quite a long time to run and so where there are two SDKs on a single platform usually only one of them will run the cellular tests to keep the execution time down.

# Maintenance
- When adding a new API make sure that it is present in at least one of the entries above, otherwise it may NOT be detected and tested at all on a branch that is NOT `master` (where a smaller, focused set of tests are carried out).
