/*
 * Copyright 2019-2024 u-blox
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _U_PORT_OS_PRIVATE_H_
#define _U_PORT_OS_PRIVATE_H_

/** @file
 * @brief Stuff private to the OS part of the Linux porting layer.
 */

#ifdef __cplusplus
extern "C" {
#endif

/* ----------------------------------------------------------------
 * COMPILE-TIME MACROS
 * -------------------------------------------------------------- */

/* ----------------------------------------------------------------
 * TYPES
 * -------------------------------------------------------------- */

/* ----------------------------------------------------------------
 * FUNCTIONS: OS PORT FUNCTIONS THAT ARE PRIVATE TO THE PORTING LAYER
 * -------------------------------------------------------------- */

/** Initialise the private bits of the OS of the porting layer.
 *
 * @return: zero on success else negative error code.
 */
int32_t uPortOsPrivateInit(void);

/** Deinitialise the private bits of the OS of the porting layer.
 */
void uPortOsPrivateDeinit(void);

#ifdef __cplusplus
}
#endif

#endif  // _U_PORT_OS_PRIVATE_H_

// End of file
