# Introduction
This directory provides various utilities used by the other `ubxlib` components.

## [u_ringbuffer](api/u_ringbuffer.h)
A simple ring buffer implementation that functions as a wrapper for a linear buffer.
All API functions except `uRingBufferCreate()` and `uRingBufferDelete()` are thread-safe.

## [u_hex_bin_convert](api/u_hex_bin_convert.h)
Functions to convert a buffer of ASCII hex encoded into a buffer of binary and vice-versa.

## [u_time](api/u_time.h)
Functions to assist with time manipulation.

## [u_base64](api/u_base64.h)
Functions to convert to and from base64.

## [u_mempool](api/u_mempool.h)
A memory pool API used internally by the short-range code for efficient EDM transport.

## [u_interface](api/u_interface.h)
Functions to help when creating interface types (i.e. jump-tables).

## [u_linked_list](api/u_linked_list.h)
A linked list utility.
